var currentLanguage = 'de';

function IsEnglishLanguage() {
    if (currentLanguage === 'en') {
        return true;
    }

    return false;
}

var language = {
    eng: {
        menu: 'Menu',
        settings: 'Settings',
        openRobotManagement: 'Robot management',
        openBackupManagement: 'Backup management',
        openBackupJobs: 'Backup tasks',
        treeView: 'Tree view',
        diagnostic: 'Generate diagnostic package',
        encryptPassword: 'Encrypt password',
        searchbarPlaceholder: 'Search for robots',
        overview: 'Overview',
        history: 'History',
        messages: 'Messages',
        infoMessageText: 'No message available...',
        noRobotsAvailableBtn: 'Search for robots',
        backupBtn: 'Backup',
        selectionBtn: 'Selection',
        selectionActionBtn: 'Selection action',
        historyPageTitle: 'Backup history',
        hitoryPageTimestamp: 'Time stamp',
        hitoryPageName: 'Backup task name or requested by',
        hitoryPageRobCount: 'Number of robots',
        hitoryPageInfo: 'Info',
        messagesPageTitle: 'Messages',
        robotImportStarted: 'Robot import started, please wait ..',
        robotImportFinished: 'Robot import finished. No robots could be imported',
        searchingForRobotsStarted: 'Searching for robots in the network, please wait ...',
        searchingForRobotsFinished: 'Search finished, no robots found!',
        noNewRobotsFound: 'No new robots were found!',
        showNewRobotsPopupTitle: 'Shall the new robots be taken over?',
        showNewRobotsPopupOverview: 'Overview',
        showNewRobotsPopupRobotsFound: ' robots found',
        showNewRobotsPopupNewRobots: ' new robots',
        showNewRobotsPopupStillAvailableRobots: ' existing robots',
        showNewRobotsPopupStillNewRobotsTitle: 'New robots',
        showNewRobotsPopupStillAvailableTitle: 'Existing robots',
        showNewRobotsPopupBackupNewRobots: ' Backup the new robots after takeover?',
        addingNewRobotSuccessful: 'Robots have been added successfully!',
        noRobotInfoAvailable: 'There are no additional informations for this robot!',
        backupNow: 'Backup now',
        restoreNow: 'Restore now',
        restoreAssistent: 'Restore assistent',
        robotInfoUpdateTimeStamp: 'Last update: ',
        robotInfo: 'Robot informations',
        robotType: 'Robot typ',
        serialNr: 'Serial number',
        kssVerion: 'KSS version',
        availableBackups: 'Available backups',
        installedOptions: 'Installed options',
        deleteRobotBtn: 'Delete robot',

        robotManagementDialogTitle: 'Robot management',
        robotManagementDialogSearchForRobots: 'Search for robots',
        robotManagementDialogAddRobot: 'Add robot manually',
        robotManagementDialogImport: 'Import robot list',
        robotManagementDialogGroupRobots: 'Group robots',

        enterIpAdress: 'Please enter the IP address of the new robot',
        invalidIpAdress: 'The given IP address is invalid!',
        confirmIpAdress: 'Is the given IP address correct?',

        robotAddedSuccessfully: 'The robot was added successfully!',
        robotAddedStillAvailable: 'A robot with the given IP address already exists!',
        robotAddedError: 'An error occurred while adding!',

        invalidFileExtension: 'Invalid file extension!',

        noBackupJobsAvailable: 'No scheduled backup tasks available!',
        createNewBackupJob: 'Create new task',
        deleteBackupJob: 'Are you sure you want to delete the task?',
        deleteBackupJobError: 'An error occurred while deleting the task!',
        deleteBackupJobNotAvailable: 'Task to be deleted does not exist!',
        backupJobAddedSuccessfully: 'The task was successfully deleted!',

        backupJobPopupTitle: 'Create backup task',
        backupJobEditPopupTitle: 'Edit backup task',
        backupJobPopupName: 'Name of backup task',
        backupJobPopupEmailPlaceholder: 'Semicolon (;) separated',
        backupJobPopupTimePlaceholder: 'Select time',
        backupJobPopupRobotSelection: 'Robot selection',

        backupJobCheckNoName: 'No name given!',
        backupJobCheckNoTime: 'No time given!',
        backupJobCheckNoDays: 'No weekday selected!',
        backupJobCheckNoRobots: 'No robot selected!',

        backupJobStartError: 'Error: Task could not be started!',
        backupJobStartOk: 'Task is started!',

        backupJobEditError: 'Error: Task could not be updated!',
        backupJobEditEqual: 'Task was not changed and is therefore not updated!',
        backupJobEditOk: 'Task updated successfully',

        backupJobCreateError: 'Error: Task could not be created!',
        backupJobCreateAlreadyExists: 'Task with the same name already exists!',
        backupJobCreateOk: 'Task created successfully!',

        noBackupJobsRunning: 'No backup task is currently being processed!',
        backupJobOverviewPopupTitle: 'Overview of the current backup tasks',
        backupJobOverviewPopupRunning: 'Processing',
        backupJobOverviewPopupWaiting: 'Queued',

        backupJobCancelError: 'The backup task failed to cancel!',
        backupJobCancelOk: 'Backup task was canceled successfully!',

        backupAll: 'Backup all',
        backupSelected: 'Backup selected',

        selectAll: 'Select all',
        selectReset: 'Reset selection',
        selectInvert: 'Invert selection',
        selectDelete: 'Delete selection',
        deleteAll: 'Delete all robots',
        createJobFromSelection: 'Create task from selection',

        deleteRobotsPopupTitle: 'Are you sure you want to delete the following robots?',
        deleteAllRobots: 'Are you sure you want to delete all robots?',


        deleteAllRobotsSuccessful: 'All selected robots have been successfully removed!',
        deleteRobotsSuccessful: ' selected robots have been successfully removed, ',
        deleteRobotsFailed: ' selected robots were not removed!',
        deleteRobot: 'Are you sure you want to delete the robot?',

        deleteRobotSuccessful: 'The robot was successfully removed!',
        deleteRobotNotAvailable: 'The robot does not exist!',
        deleteRobotNoIp: 'The robot could not be removed because no IP address was given!',
        deleteRobotError: 'Error: Robot could not be removed!',

        backupRobot: 'Should the following robots be backed up?',

        noHistoryElements: 'No history elements available...',
        backupFrom: 'Backup from ',

        createDiagError: 'Error: Diagnostic package could not be created!',
        createDiagOk: 'The diagnostic package was created successfully and  is now ready for download!',

        downloadBackupError: 'Error: archive cannot be downloaded!',
        downloadBackupOk: 'The selected archive is now ready for download!',

        restoreBackup: 'Should the selected backup be restored?',
        restoreRobot: 'Should the most recent backup be restored?',

        //##
        restoreAssistentTitle: 'Do you want to restore the latest or an older backup?',
        restoreAssistentNewest: 'Latest',
        restoreAssistentOlder: 'An older',

        restoreAssistentForNewestTitle: 'Restore assistant for the latest backup',

        restoreAssistentLogin: 'Login',
        restoreAssistentLoginHeader: 'Login at least as Expert on the robot controller.',
        restoreAssistentLoginStep1: 'Call up the main menu (button with robot at the bottom right or top left of the SmartPad)',
        restoreAssistentLoginStep2: 'Click „Configuration“',
        restoreAssistentLoginStep3: 'Click „User group“, select at least „Expert“, enter password and click „Log on“',

        restoreAssistentRestore: 'Restore',
        restoreAssistentRestoreHeader: 'Restore backup',
        restoreAssistentRestoreStep1: 'Call up the main menu (button with robot at the bottom right or top left of the SmartPad)',
        restoreAssistentRestoreStep2: 'Click „File“',
        restoreAssistentRestoreStep3: 'Click „Backup Manager“',
        restoreAssistentRestoreStep4: 'Click „Restore“',
        restoreAssistentRestoreStep41: 'Click „Restore from...“',
        restoreAssistentRestoreStep5: 'Click „Projects and options“',

        restoreAssistentActivation: 'Project activation',
        restoreAssistentActivationHeader: 'Allow project activation',
        restoreAssistentActivationStep1: 'Answer the following dialog „Do you want to activate ...“ with „Yes“',

        restoreAssistentChangings: 'Project changes',
        restoreAssistentChangingsHeader: 'Confirm project changes',
        restoreAssistentChangingsStep1: 'Confirm the „Do you want to continue?“ Dialog with „Yes“',

        restoreAssistentFinish: 'Completion',
        restoreAssistentFinishHeader: 'The restore is now carried out, which may include restarting the robot.',

        restoreAssistentForOlderTitle: 'Restore assistent for an older backup',

        restoreAssistentBackupSelection: 'Backup selection',
        restoreAssistentBackupSelectionHeader: 'Select source path of the project to be restored',
        restoreAssistentBackupSelectionStep1: 'Click „Browse“',
        restoreAssistentBackupSelectionStep2: 'Select the path to the desired backup and confirm with „OK“',
        restoreAssistentBackupSelectionStep3: 'Click „Restore“',

        licenceInfo: 'License info',
        lastLicenceCheckLbl: 'Last check: ',
        productNameLbl: 'Product name',
        productIdLbl: 'Product ID',

        licenceUnlimited: 'License unlimited!',
        licenceUnits: 'Max. number of robots according to license',
        licenceLimitedInDays: 'License still valid in days',
        noLicenceAvailable: 'No license available!',
        noValidLicence: 'No valid license file available for product ID:',
        licenceRequest1: 'If necessary, ask ',
        licenceRequest2: ' about a valid license by specifying the product ID shown above.',
        licenceUpload: 'Load license',
        licenceRequest: 'Request license',
        noValidLicenceWarning: ' cannot be used without a valid license!',
        noValidLicenceAvailable: 'No (valid) license available!',
        licenceUploadError: 'Error transferring or saving the license file: ',

        noRobotsSelected: 'No robots selected!',
        jobNotFound: 'Task not found!',
        executeNow: 'Run task now',
        connectionLost: 'Connection to the server lost...',
        robotListChanged: 'Robot list has changed and has been reloaded!',
        usernameAndPassword: 'Enter username and password...',
        password: 'Enter password...',
        checkMessages: 'Check the messages in the messages tab.',
        noDataSendToServer: 'Error: No data was transferred to the server!',

        RobotNotReachable: 'Ping failed',
        NoProjectBackupDirectory: 'No ProjectBackupDirectoryPath given!',
        NoKopBackupDirectoryPath: 'No KopBackupDirectoryPath given!',
        DecomposerNoProjectFileAvailable: 'No project file to decompose!',

        ok: 'OK',
        cancel: 'Cancel',
        close: 'Close',
        back: 'Back',
        assume: 'Assume',
        yes: 'Yes',
        no: 'No',
        days: 'Day (s)',
        time: 'Time',
        robotCount: 'Number of robots',
        required: 'required',
        optional: 'optional',
        email: 'Email (s)',
        weekdays: 'Weekday (s)',
        successful: 'Successful',

        noDownloadPath: 'No download path given!',
        notSupported: 'This feature is not supported in this browser!',
        functionNotAvailable: 'This feature is currently not available!'
    },
    de: {
        menu: 'Menü',
        settings: 'Einstellungen',
        openRobotManagement: 'Roboterverwaltung',
        openBackupManagement: 'Backupverwaltung',
        openBackupJobs: 'Backup-Aufgaben',
        treeView: 'Baumansicht',
        diagnostic: 'Diagnosepaket erstellen',
        encryptPassword: 'Passwort verschlüsseln',
        searchbarPlaceholder: 'Nach Robotern suchen',
        overview: 'Übersicht',
        history: 'Verlauf',
        messages: 'Meldungen',
        infoMessageText: 'Keine Meldung verfügbar...',
        noRobotsAvailableBtn: 'Nach Robotern suchen',
        backupBtn: 'Archivieren',
        selectionBtn: 'Auswahl',
        selectionActionBtn: 'Auswahl Aktion',
        historyPageTitle: 'Backup-Verlauf',
        hitoryPageTimestamp: 'Zeitstempel',
        hitoryPageName: 'Name der Backup-Aufgabe bzw. angefordert von',
        hitoryPageInfo: 'Info',
        messagesPageTitle: 'Meldungen',
        robotImportStarted: 'Roboter-Import gestartet, bitte warten...',
        robotImportFinished: 'Roboter-Import beendet. Es konnten keine Roboter importiert werden!',
        searchingForRobotsStarted: 'Es wird nach Robotern im Netzwerk gesucht, bitte warten...',
        searchingForRobotsFinished: 'Suche beendet, es wurden keine Roboter gefunden!',
        noNewRobotsFound: 'Es wurden keine neuen Roboter gefunden!',
        showNewRobotsPopupTitle: 'Sollen die neuen Roboter übernommen werden?',
        showNewRobotsPopupOverview: 'Übersicht',
        showNewRobotsPopupRobotsFound: ' Roboter gefunden',
        showNewRobotsPopupNewRobots: ' neue Roboter',
        showNewRobotsPopupStillAvailableRobots: ' bereits bestehende Roboter',
        showNewRobotsPopupStillNewRobotsTitle: 'Neue Roboter',
        showNewRobotsPopupStillAvailableTitle: 'Bereits bestehende Roboter',
        showNewRobotsPopupBackupNewRobots: ' Nach Übernahme die neuen Roboter archivieren?',
        addingNewRobotSuccessful: 'Roboter wurden erfolgreich hinzugefügt!',
        noRobotInfoAvailable: 'Für diesen Roboter sind keine zusätzlichen Infos vorhanden!',
        backupNow: 'Jetzt archivieren',
        restoreNow: 'Jetzt wiederherstellen',
        restoreAssistent: 'Wiederherstellungs-Assistent',
        robotInfoUpdateTimeStamp: 'Letzte Aktualisierung: ',
        robotInfo: 'Roboter-Informationen',
        robotType: 'Roboter-Typ',
        serialNr: 'Seriennummer',
        kssVerion: 'KSS-Version',
        availableBackups: 'Verfügbare Sicherungen',
        installedOptions: 'Installierte Optionen',
        deleteRobotBtn: 'Roboter löschen',

        robotManagementDialogTitle: 'Roboterverwaltung',
        robotManagementDialogSearchForRobots: 'Nach Robotern suchen',
        robotManagementDialogAddRobot: 'Roboter manuell hinzufügen',
        robotManagementDialogImport: 'Roboterliste importieren',
        robotManagementDialogGroupRobots: 'Roboter gruppieren',

        enterIpAdress: 'Bitte die IP-Adresse des neuen Roboters eingeben',
        invalidIpAdress: 'Die angegebene IP-Adresse ist ungültig!',
        confirmIpAdress: 'Ist die IP-Adresse korrekt?',

        robotAddedSuccessfully: 'Der Roboter wurde erfolgreich hinzugefügt!',
        robotAddedStillAvailable: 'Ein Roboter mit der angegebenen IP-Adresse ist bereits vorhanden!',
        robotAddedError: 'Beim Hinzufügen ist ein Fehler aufgetreten!',

        invalidFileExtension: 'Ungültige Dateiendung!',

        noBackupJobsAvailable: 'Keine geplanten Backup-Aufgaben vorhanden!',
        createNewBackupJob: 'Neue Aufgabe erstellen',
        deleteBackupJob: 'Soll die Aufgabe wirklich gelöscht werden?',
        deleteBackupJobError: 'Beim Löschen der Aufgabe ist ein Fehler aufgetreten!',
        deleteBackupJobNotAvailable: 'Zu löschende Aufgabe nicht vorhanden!',
        backupJobAddedSuccessfully: 'Die Aufgabe wurde erfolgreich gelöscht!',

        noRobotsAvailable: 'Keine Roboter zur Auswahl vorhanden!',

        backupJobPopupTitle: 'Backup-Aufgabe erstellen',
        backupJobEditPopupTitle: 'Backup-Aufgabe bearbeiten',
        backupJobPopupName: 'Name der Backup-Aufgabe',
        backupJobPopupEmailPlaceholder: 'Semikolon(;) getrennt',
        backupJobPopupTimePlaceholder: 'Uhrzeit auswählen',
        backupJobPopupRobotSelection: 'Roboterauswahl',

        backupJobCheckNoName: 'Kein Name angegeben!',
        backupJobCheckNoTime: 'Keine Uhrzeit angegeben!',
        backupJobCheckNoDays: 'Kein Wochentag angegeben!',
        backupJobCheckNoRobots: 'Kein Roboter ausgewählt!',

        backupJobStartError: 'Fehler: Aufgabe konnte nicht gestartet werden!',
        backupJobStartOk: 'Aufgabe wird gestartet!',

        backupJobEditError: 'Fehler: Aufgabe konnte nicht bearbeitet werden!',
        backupJobEditEqual: 'Aufgabe wurde nicht verändert und wird deshalb nicht aktualisiert!',
        backupJobEditOk: 'Aufgabe erfolgreich aktualisiert!',

        backupJobCreateError: 'Fehler: Aufgabe konnte nicht erstellt werden!',
        backupJobCreateAlreadyExists: 'Aufgabe mit gleichem Namen bereits vorhanden!',
        backupJobCreateOk: 'Aufgabe erfolgreich erstellt!',

        noBackupJobsRunning: 'Aktuell ist keine Backup-Aufgabe in Bearbeitung!',
        backupJobOverviewPopupTitle: 'Übersicht der aktuellen Backup-Aufgaben',
        backupJobOverviewPopupRunning: 'In Bearbeitung',
        backupJobOverviewPopupWaiting: 'In Warteschlange',

        backupJobCancelError: 'Abbrechen der Backup-Aufgabe fehlgeschlagen!',
        backupJobCancelOk: 'Backup-Aufgabe wurde erfolgreich abgebrochen!',

        backupAll: 'Alle archivieren',
        backupSelected: 'Auswahl archivieren',

        selectAll: 'Alle auswählen',
        selectReset: 'Auswahl zurücksetzen',
        selectInvert: 'Auswahl invertieren',
        selectDelete: 'Auswahl löschen',
        deleteAll: 'Alle Roboter löschen',
        createJobFromSelection: 'Aufgabe aus Auswahl erstellen',

        deleteRobotsPopupTitle: 'Sollen folgende Roboter wirklich gelöscht werden?',
        deleteAllRobots: 'Sollen wirklich alle Roboter gelöscht werden?',

        deleteAllRobotsSuccessful: 'Alle ausgewählten Roboter wurden erfolgreich entfernt!',
        deleteRobotsSuccessful: ' ausgewählte Roboter wurden erfolgreich entfernt, ',
        deleteRobotsFailed: ' ausgewählte Roboter wurden nicht entfernt!',
        deleteRobot: 'Soll der Roboter wirklich gelöscht werden?',

        deleteRobotSuccessful: 'Der Roboter wurde erfolgreich entfernt!',
        deleteRobotNotAvailable: 'Der Roboter ist nicht vorhanden!',
        deleteRobotNoIp: 'Der Roboter konnte nicht entfernt werden weil keine IP-Adresse angegeben wurde!',
        deleteRobotError: 'Fehler: Roboter konnte nicht entfernt werden!',

        backupRobot: 'Sollen folgende Roboter archiviert werden?',

        noHistoryElements: 'Keine History-Elemente vorhanden...',
        backupFrom: 'Backup vom ',

        createDiagError: 'Fehler: Diagnosepaket konnte nicht erstellt werden!',
        createDiagOk: 'Das Diagnose-Paket wurde erfolgreich erstellt und steht nun zum Download bereit!',

        downloadBackupError: 'Fehler: Archiv kann nicht heruntergeladen werden!',
        downloadBackupOk: 'Das ausgewählte Archiv steht nun zum Download bereit!',

        restoreBackup: 'Soll das ausgewählte Backup wiederhergestellt werden?',
        restoreRobot: 'Soll das aktuellste Backup wiederhergestellt werden?',

        restoreAssistentTitle: 'Wollen Sie das Neueste oder ein älteres Backup wiederherstellen?',
        restoreAssistentNewest: 'Neueste',
        restoreAssistentOlder: 'Ein älteres',

        restoreAssistentForNewestTitle: 'Wiederherstellungs-Assistent für das Neueste Backup',

        restoreAssistentLogin: 'Anmelden',
        restoreAssistentLoginHeader: 'Mindestens als Experte an der Roboter-Steuerung anmelden.',
        restoreAssistentLoginStep1: 'Hauptmenü aufrufen (Taste mit Roboter unten rechts bzw. oben links am SmartPad)',
        restoreAssistentLoginStep2: '„Konfiguration“ klicken',
        restoreAssistentLoginStep3: '"Benutzergruppe“ klicken, mindestens „Experte“ auswählen, Passwort eingeben und „Anmelden“ klicken',

        restoreAssistentRestore: 'Wiederherstellen',
        restoreAssistentRestoreHeader: 'Backup wiederherstellen',
        restoreAssistentRestoreStep1: 'Hauptmenü aufrufen (Taste mit Roboter unten rechts bzw. oben links am SmartPad)',
        restoreAssistentRestoreStep2: '„Datei“ klicken',
        restoreAssistentRestoreStep3: '„Backup-Manager“ klicken',
        restoreAssistentRestoreStep4: '„Wiederherstellen“ klicken',
        restoreAssistentRestoreStep41: '„Wiederherstellen von...“ klicken',
        restoreAssistentRestoreStep5: '„Projekte und Optionen“ klicken',

        restoreAssistentActivation: 'Projekt-Aktivierung',
        restoreAssistentActivationHeader: 'Aktivierung des Projekts zulassen',
        restoreAssistentActivationStep1: 'Den darauffolgenden Dialog „Wollen Sie die Aktivierung…“ mit „Ja“ beantworten',

        restoreAssistentChangings: 'Projekt-Änderungen',
        restoreAssistentChangingsHeader: 'Projekt-Änderungen bestätigen',
        restoreAssistentChangingsStep1: 'Den Dialog „Wollen Sie fortfahren?“ mit „Ja“ bestätigen',

        restoreAssistentFinish: 'Abschluss',
        restoreAssistentFinishHeader: 'Die Wiederherstellung wird nun durchgeführt was ggfs. einen Neustart des Roboters beinhalten kann.',

        restoreAssistentForOlderTitle: 'Wiederherstellungs-Assistent für ein älteres Backup',

        restoreAssistentBackupSelection: 'Backup-Auswahl',
        restoreAssistentBackupSelectionHeader: 'Quellpfad des wiederherzustellenden Projekts auswählen',
        restoreAssistentBackupSelectionStep1: '„Durchsuchen“ klicken',
        restoreAssistentBackupSelectionStep2: 'Pfad zum gewünschten Backup auswählen und mit „OK“ bestätigen',
        restoreAssistentBackupSelectionStep3: '„Wiederherstellen“ klicken',

        licenceInfo: 'Lizenz-Info',
        lastLicenceCheckLbl: 'Letze Überprüfung: ',
        productNameLbl: 'Produkt-Name',
        productIdLbl: 'Produkt-ID',

        licenceUnlimited: 'Lizenz unbegrenzt gültig!',
        licenceUnits: 'Max. Anzahl an Robotern laut Lizenz',
        licenceLimitedInDays: 'Lizenz noch gültig in Tagen',
        noLicenceAvailable: 'Keine Lizenz vorhanden!',
        noValidLicence: 'Keine gültige Lizenz-Datei vorhanden für Produkt-ID:',
        licenceRequest1: 'Fordern Sie ggfs. über ',
        licenceRequest2: ' unter Angabe der oben angezeigten Produkt-ID eine gültige Lizenz an.',
        licenceUpload: 'Lizenz laden',
        licenceRequest: 'Lizenz anfordern',
        noValidLicenceWarning: ' kann ohne gültige Lizenz nicht verwendet werden!',
        noValidLicenceAvailable: 'Keine (gültige) Lizenz vorhanden! Seite wird neu geladen!',
        licenceUploadError: 'Fehler beim Übertragen oder Speichern der Lizenzdatei: ',

        noRobotsSelected: 'Es wurden keine Roboter ausgewählt!',
        jobNotFound: 'Aufgabe nicht gefunden!',
        executeNow: 'Aufgabe jetzt ausführen',
        connectionLost: 'Verbindung zum Server unterbrochen...',
        robotListChanged: 'Roboterliste hat sich geändert und wurde neu geladen!',
        usernameAndPassword: 'Benutzername und Passwort eingeben...',
        password: 'Passwort eingeben...',
        checkMessages: 'Überprüfen Sie die Meldungen im Meldungen-Tab.',
        noDataSendToServer: 'Fehler: Es wurden keine Daten zum Server übertragen!',

        RobotNotReachable: 'Ping nicht erfolgreich',
        NoProjectBackupDirectory: 'Kein ProjectBackupDirectoryPath angegeben!',
        NoKopBackupDirectoryPath: 'Kein KopBackupDirectoryPath angegeben!',
        DecomposerNoProjectFileAvailable: 'Keine Projektdatei zum Entpacken vorhanden!',

        ok: 'OK',
        cancel: 'Abbrechen',
        close: 'Schließen',
        back: 'Zurück',
        assume: 'Übernehmen',
        yes: 'Ja',
        no: 'Nein',
        days: 'Tag(e)',
        time: 'Uhrzeit',
        robotCount: 'Anzahl Roboter',
        required: 'Erforderlich',
        optional: 'Optional',
        email: 'E-Mail(s)',
        weekdays: 'Wochentag(e)',
        successful: 'Erfolgreich',

        noDownloadPath: 'Es wurde kein Download-Pfad angegeben!',
        notSupported: 'Diese Funktion wird in diesem Browser nicht unterstützt!',
        functionNotAvailable: 'Diese Funktion steht aktuell noch nicht zur Verfügung!'
    }
}

var dayOfWeek = {
    eng: {
        Sunday: 'Sunday',
        Monday: 'Monday',
        Tuesday: 'Tuesday',
        Wednesday: 'Wednesday',
        Thursday: 'Thursday',
        Friday: 'Friday',
        Saturday: 'Saturday'
    },
    de: {
        Sunday: 'Sonntag',
        Monday: 'Montag',
        Tuesday: 'Dienstag',
        Wednesday: 'Mittwoch',
        Thursday: 'Donnerstag',
        Friday: 'Freitag',
        Saturday: 'Samstag'
    }
}

if (window.location.hash) {
    if (window.location.hash !== "#de") {
        SetLanguageEng();
    }
} else if (!navigator.language.toLowerCase().includes("de")) {
    SetLanguageEng();
}

function SetLanguageEng() {
    currentLanguage = 'en';

    //index.html - Menü
    changeLanguage.textContent = 'DE'
    menu.textContent = language.eng.menu;
    openRobotManagement.textContent = language.eng.openRobotManagement;
    openBackupManagement.textContent = language.eng.openBackupManagement;
    openBackupJobs.textContent = language.eng.openBackupJobs;
    diagnostic.textContent = language.eng.diagnostic;
    restoreAssistent.textContent = language.eng.restoreAssistent;
    licenceInfo.textContent = language.eng.licenceInfo;

    //index.html
    mySearchbar.placeholder = language.eng.searchbarPlaceholder;
    mySearchbarCancel.textContent = language.eng.cancel;
    overviewTab.textContent = language.eng.overview;
    historyTab.textContent = language.eng.history;
    messagesTab.textContent = language.eng.messages;
    infoMessage.textContent = language.eng.infoMessageText;
    noRobotsAvailableBtn.textContent = language.eng.noRobotsAvailableBtn;
    backupBtn.textContent = language.eng.backupBtn;
    selectionBtn.textContent = language.eng.selectionBtn;
}

function SetHistoryPageLanguage() {
    if (IsEnglishLanguage()) {
        historyPageTitle.textContent = language.eng.historyPageTitle;
        historyPageBackBtn.textContent = language.eng.back;
        historyPageTimestamp.textContent = language.eng.hitoryPageTimestamp;
        historyPageName.textContent = language.eng.hitoryPageName;
        historyPageRobCount.textContent = language.eng.robotCount;
        historyPageInfo.textContent = language.eng.hitoryPageInfo;
    }
}

function SetMessagesPageLanguage() {
    if (IsEnglishLanguage()) {
        messagesPageTitle.textContent = language.eng.messagesPageTitle;
        messagesPageBackBtn.textContent = language.eng.back;
    }
}

changeLanguage.onclick = function () {

    if (changeLanguage.textContent === 'EN') {
        window.location.hash = "#en";
    } else {
        window.location.hash = "#de"; //#de
    }

    location.reload();
}