
const COMMANDS = {
  INIT_CLIENT: 'INIT_CLIENT',
  UPDATE_CLIENT: 'UPDATE_CLIENT',
  GET_MESSAGES: 'GET_MESSAGES',
  GET_HISTORY: 'GET_HISTORY',
  GET_SHEDULED_JOBS: 'GET_SHEDULED_JOBS',
  ADD_SHEDULED_JOB: 'ADD_SHEDULED_JOB',
  UPDATE_SHEDULED_JOB: 'UPDATE_SHEDULED_JOB',
  REMOVE_SHEDULED_JOB: 'REMOVE_SHEDULED_JOB',
  RELEASE_SHEDULED_JOBS: 'RELEASE_SHEDULED_JOBS',
  START_SHEDULED_JOB: 'START_SHEDULED_JOB',
  SEARCH_FOR_ROBOTS: 'SEARCH_FOR_ROBOTS',
  USE_NEW_FOUND_ROBOTS: 'USE_NEW_FOUND_ROBOTS',
  REFUSE_FOUND_ROBOTS: 'REFUSE_FOUND_ROBOTS',
  GET_ROBOTS: 'GET_ROBOTS',
  ADD_ROBOT: 'ADD_ROBOT',
  UPDATE_ROBOTS: 'UPDATE_ROBOTS',
  DELETE_ROBOT: 'DELETE_ROBOT',
  DELETE_ROBOTS: 'DELETE_ROBOTS',
  DELETE_ALL_ROBOTS: 'DELETE_ALL_ROBOTS',
  UPLOAD_CSV: 'UPLOAD_CSV',
  REFUSE_IMPORTED_ROBOTS: 'REFUSE_IMPORTED_ROBOTS',
  USE_NEW_IMPORTED_ROBOTS: 'USE_NEW_IMPORTED_ROBOTS',
  BACKUP_ROBOT: 'BACKUP_ROBOT',
  BACKUP_ROBOTS: 'BACKUP_ROBOTS',
  BACKUP_ALL_ROBOTS: 'BACKUP_ALL_ROBOTS',
  CANCEL_JOB: 'CANCEL_JOB',
  CREATE_DIAG: 'CREATE_DIAG',
  DOWNLOAD_BACKUP: 'DOWNLOAD_BACKUP',
  // RESTORE_BACKUP: 'RESTORE_BACKUP',
  // RESTORE_ROBOT: 'RESTORE_ROBOT',
  GET_LICENCE_STATE: 'GET_LICENCE_STATE',
  UPLOAD_LIC: 'UPLOAD_LIC'
}

const BACKUP_STATE = {
  NO_BACKUPS: 'ledRed',
  BACKUP_RUNNING: 'ledBlue',
  BACKUP_OUT_OF_DATE: 'ledOrange',
  BACKUP_OK: 'ledGreen',
}

const BACKUP_PROGRESS_STATES = {
  IDLE: 'IDLE',
  BACKUP_REQUESTED: 'BACKUP_REQUESTED',
  BACKUP_STARTET: 'IDBACKUP_STARTETLE',
  BACKUP_FINISHED: 'BACKUP_FINISHED',
  BACKUP_ERROR: 'BACKUP_ERROR',
  DECOMPOSER_STARTET: 'DECOMPOSER_STARTET',
  DECOMPOSER_FINISHED: 'DECOMPOSER_FINISHED',
  DECOMPOSER_ERROR: 'DECOMPOSER_ERROR'
}

const DO_LOG = true;

var sessionId;

function log(obj) {

  if (!DO_LOG) {
    return;
  }

  console.log(obj);
}

function createSessionId() {
  sessionId = sessionStorage.getItem('id');
  //id: "dcca59b1-0589-4473-b3d9-a6ab7304116c"

  if (!sessionId) {
    sessionStorage.setItem('id', create_UUID());
    sessionId = sessionStorage.getItem('id');
  }
}

function create_UUID() {
  var dt = new Date().getTime();
  var uuid = 'xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx'.replace(/[xy]/g, function (c) {
    var r = (dt + Math.random() * 16) % 16 | 0;
    dt = Math.floor(dt / 16);
    return (c == 'x' ? r : (r & 0x3 | 0x8)).toString(16);
  });
  return uuid;
}

function FunctionNotAvailable() {
  t = language.de.functionNotAvailable;
  if (IsEnglishLanguage()) {
    t = language.eng.functionNotAvailable;
  }
  app.dialog.alert(t, '');
}

function RobotsToRobotsIpList(robots) {

  if (!robots) {
    return null;
  }

  robIps = [];
  robots.forEach(rob => {
    robIps.push(rob.Ip);
  });

  return robIps;
}

function sendRequestToServer(command, value, callback) {
  xhttp = new XMLHttpRequest();

  xhttp.onreadystatechange = function () {
    if (this.readyState === 4 && this.status === 200) {
      console.log(command + ': ' + this.responseText);

      if (callback) {
        callback(this.responseText);
      }
    }
  };

  xhttp.ontimeout = function (e) {
    log("XMLHttpRequest timed out...");
  };

  url = 'cmd?' + command + '=' + value;

  xhttp.timeout = 10000; // time in milliseconds
  xhttp.open('GET', url, true);
  xhttp.send();
}

function postToServer(command, formData, callback) {
  // XMLHttpRequest aufstellen
  xhr = new XMLHttpRequest();

  // Platzhalter für den Ladefortschritt
  xhr.upload.onprogress = function (e) {
    percentUpload = Math.floor(100 * e.loaded / e.total);

  }

  // Event Handler für die Response vom Server
  xhr.onload = function () {
    if (xhr.status === 200) {
      // Dateien wurden hochgeladen
      // console.log(postToServer + ': ' + this.responseText);

      if (callback) {
        callback(this.responseText);
      }
    } else {

    }
  };

  url = 'cmd?' + command;

  // Verbindung zur Anwendung aufbauen
  xhr.open('POST', url, true);
  // Daten übertragen
  xhr.send(formData);
}

function Sleep(milliseconds) {
  return new Promise(resolve => setTimeout(resolve, milliseconds));
}

function RemoveAllChilds(element) {

  if (element === null) {
    return;
  }

  // As long as element has a child node, remove it
  while (element.hasChildNodes()) {
    element.removeChild(element.firstChild);
  }
}

function ValidateIPaddress(inputText) {
  var ipformat = /^(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$/;
  if (inputText.match(ipformat)) {
    return true;
  }
  else {
    return false;
  }
}

function StringIsNullOrEmpty(s) {
  if (!s) {
    return true;
  }

  if (s === null) {
    return true;
  }

  if (s === undefined) {
    return true;
  }

  if (s === '') {
    return true;
  }

  return false;
}
